// application base class
Control_class	= Object_class:create( "Control_class" );

// application create method.
function Control_class:create( parent, create_vgui, classname )
	// create app object
	local obj = {};
	setmetatable( obj, self );
	self.__index = self;
	
	// store classname
	obj.classname = classname;
	
	// controls list
	obj.controls = {};
	
	// events
	obj.events = {};
	
	// create app window.
	if( create_vgui == true or create_vgui == nil ) then
		obj.window = vgui.Create( classname or self.classname, parent );
		obj.window:LinkToClass( obj );
	end
		
	// add a destroy method
	obj:onDestroy( "Destroyed" );

	//
	return obj;
end


// add event handler.
function Control_class:AddEvent( event, func, app )
	// add to this event.
	self.events[event] = self.events[event] or {};
	table.insert( self.events[event], { app = app or self, func = func } );
end

// call event
function Control_class:CallEvent( event, ... )
	self.events[event] = self.events[event] or {};
	
	// call all items in this event.
	local e, ret;
	for _, e in pairs( self.events[event] ) do
		if( e.app[e.func] ) then
			ret = e.app[e.func]( e.app, unpack( arg ) );
		end
	end
	
	//
	return ret;
end


// destroy method
function Control_class:Destroyed( )
	// call app quit event.
	self:OnShutdown( );
	
	// destroy controls.
	local control;
	for _, control in pairs( self.controls ) do
		control:destroy();
	end
	
	// remove the window
	if( self:ValidHandle() ) then
		self.window:Remove();
	end
end

// pos/size
function Control_class:SetSize( w, h )
	// valid?
	if( !self:ValidHandle() ) then return; end
	
	self.window:SetSize( w, h );
end
function Control_class:SetPos( x, y )
	// valid?
	if( !self:ValidHandle() ) then return; end
	
	self.window:SetPos( x, y );
end

// get pos
function Control_class:GetPos( )
	// valid?
	if( !self:ValidHandle() ) then return 0, 0; end
	
	local x, y = self.window:GetPos();
	return x, y;
end

// get size
function Control_class:GetSize( )
	// valid?
	if( !self:ValidHandle() ) then return 0, 0; end
	
	local w, h = self.window:GetSize();
	return w, h;
end

// visibility
function Control_class:Show( )
	// valid?
	if( !self:ValidHandle() ) then return; end
	
	self.window:SetVisible( true );
end
function Control_class:Hide( )
	// valid?
	if( !self:ValidHandle() ) then return; end
	
	self.window:SetVisible( false );
end
function Control_class:IsVisible( )
	// valid?
	if( !self:ValidHandle() ) then return false; end
	
	return self.window:IsVisible();
end

// get window handle
function Control_class:GetHandle( )
	return self.window;
end

// handle valid
function Control_class:ValidHandle( )
	return self.window != nil;
end

